/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.producer;

import android.content.Context;
import android.text.TextUtils;
import com.alibabacloud.rum.producer.LogProducerException;
import com.alibabacloud.rum.producer.LogProducerTimeUnixFunc;
import com.alibabacloud.rum.producer.internal.HttpHeader;
import com.alibabacloud.rum.producer.internal.LogProducerHttpHeaderInjector;
import com.alibabacloud.rum.producer.utils.ProcessUtils;
import com.alibabacloud.rum.producer.utils.TimeUtils;
import com.alibabacloud.rum.producer.utils.Utils;
import java.io.File;
import org.jetbrains.annotations.TestOnly;

public class LogProducerConfig {
    private static NativeLibraryLoader nativeLibraryLoader = new DefaultNativeLibraryLoader(null);
    private static volatile boolean isNativeLibraryLoaded = false;
    private final long config;
    private final Context context;
    private String endpoint;
    private String project;
    private String logstore;
    private String isRum;
    private boolean enablePersistent = false;

    private static synchronized void loadNativeLibrary() {
        if (!isNativeLibraryLoaded) {
            try {
                nativeLibraryLoader.loadLibrary("producer");
                isNativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
    }

    @TestOnly
    public static void setNativeLibraryLoader(NativeLibraryLoader loader) {
        nativeLibraryLoader = loader;
    }

    @TestOnly
    public static void resetNativeLibraryLoader() {
        nativeLibraryLoader = new DefaultNativeLibraryLoader(null);
    }

    @TestOnly
    public static void resetLoadState() {
        isNativeLibraryLoaded = false;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public LogProducerConfig(Context context, long mockConfig) {
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.config = var2_2;
    }

    public LogProducerConfig() throws LogProducerException {
        this(Utils.getContext());
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(String endpoint, String project, String logstore) throws LogProducerException {
        this(Utils.getContext(), (String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret, String isRum) throws LogProducerException {
        this((String)var1_1, (String)var2_2, (String)var3_3, (String)var4_4, (String)var5_5, null, (String)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret, String securityToken, String isRum) throws LogProducerException {
        this(Utils.getContext(), (String)var1_1, (String)var2_2, (String)var3_3, (String)var4_4, (String)var5_5, (String)var6_6, (String)var7_7);
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(Context context) throws LogProducerException {
        this((Context)var1_1, null, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(Context context, String endpoint, String project, String logstore) throws LogProducerException {
        this((Context)var1_1, (String)var2_2, (String)var3_3, (String)var4_4, null, null);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(Context context, String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret) throws LogProducerException {
        this((Context)var1_1, (String)var2_2, (String)var3_3, (String)var4_4, (String)var5_5, (String)var6_6, null, null);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerConfig(Context context, String endpoint, String project, String logstore, String accessKeyId, String accessKeySecret, String securityToken, String isRum) throws LogProducerException {
        long l2;
        void var1_1;
        this.context = var1_1;
        this.config = l2 = LogProducerConfig.create_log_producer_config();
        if (l2 != 0L) {
            void var7_7;
            void var8_8;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            LogProducerConfig logProducerConfig = this;
            logProducerConfig.setSource("Android");
            logProducerConfig.setPacketTimeout(3000);
            logProducerConfig.setPacketLogCount(1024);
            logProducerConfig.setPacketLogBytes(0x100000);
            logProducerConfig.setSendThreadCount(1);
            logProducerConfig.setDropUnauthorizedLog(0);
            logProducerConfig.setDropDelayLog(0);
            logProducerConfig.setGetTimeUnixFunc(new LogProducerTimeUnixFunc(this){
                public final /* synthetic */ LogProducerConfig this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public long getTimeUnix() {
                    return TimeUtils.getInstance().getTimeInMillis();
                }
            });
            logProducerConfig.setHttpHeaderInjector(new LogProducerHttpHeaderInjector(this){
                public final /* synthetic */ LogProducerConfig this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public String[] injectHeaders(String[] srcHeaders, int count) {
                    return HttpHeader.getHeadersWithUA(srcHeaders, new String[0]);
                }
            });
            this.setEndpoint((String)var2_2);
            this.setProject((String)var3_3);
            this.setLogstore((String)var4_4);
            this.setAccessKeyId((String)var5_5);
            this.setAccessKeySecret((String)var6_6);
            this.setIsRum((String)var8_8);
            if (!TextUtils.isEmpty((CharSequence)var7_7)) {
                this.resetSecurityToken((String)var5_5, (String)var6_6, (String)var7_7);
            }
            return;
        }
        throw new LogProducerException("Can not create log producer config");
    }

    public static native long create_log_producer_config();

    private static native void log_producer_debug();

    private static native void log_producer_config_set_endpoint(long var0, String var2);

    private static native void log_producer_config_set_project(long var0, String var2);

    private static native void log_producer_config_set_logstore(long var0, String var2);

    private static native void log_producer_config_set_access_id(long var0, String var2);

    private static native void log_producer_config_set_access_key(long var0, String var2);

    private static native void log_producer_config_reset_security_token(long var0, String var2, String var3, String var4);

    private static native void log_producer_config_set_isRum(long var0, String var2);

    private static native void log_producer_config_set_topic(long var0, String var2);

    private static native void log_producer_config_add_tag(long var0, String var2, String var3);

    private static native void log_producer_config_set_packet_log_bytes(long var0, int var2);

    private static native void log_producer_config_set_packet_log_count(long var0, int var2);

    private static native void log_producer_config_set_packet_timeout(long var0, int var2);

    private static native void log_producer_config_set_max_buffer_limit(long var0, int var2);

    private static native void log_producer_config_set_send_thread_count(long var0, int var2);

    private static native void log_producer_config_set_persistent(long var0, int var2);

    private static native void log_producer_config_set_persistent_file_path(long var0, String var2);

    private static native void log_producer_config_set_persistent_force_flush(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_file_count(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_file_size(long var0, int var2);

    private static native void log_producer_config_set_persistent_max_log_count(long var0, int var2);

    private static native void log_producer_config_set_using_http(long var0, int var2);

    private static native void log_producer_config_set_net_interface(long var0, String var2);

    private static native void log_producer_config_set_connect_timeout_sec(long var0, int var2);

    private static native void log_producer_config_set_send_timeout_sec(long var0, int var2);

    private static native void log_producer_config_set_destroy_flusher_wait_sec(long var0, int var2);

    private static native void log_producer_config_set_destroy_sender_wait_sec(long var0, int var2);

    private static native void log_producer_config_set_compress_type(long var0, int var2);

    private static native void log_producer_config_set_ntp_time_offset(long var0, int var2);

    private static native void log_producer_config_set_max_log_delay_time(long var0, int var2);

    private static native void log_producer_config_set_drop_delay_log(long var0, int var2);

    private static native void log_producer_config_set_get_time_unix_func(LogProducerTimeUnixFunc var0);

    private static native void log_producer_config_set_drop_unauthorized_log(long var0, int var2);

    private static native void log_producer_config_set_callback_from_sender_thread(long var0, int var2);

    private static native void log_producer_config_set_source(long var0, String var2);

    private static native int log_producer_config_is_valid(long var0);

    private static native int log_producer_persistent_config_is_enabled(long var0);

    private static native void log_producer_config_set_http_header_inject(long var0, LogProducerHttpHeaderInjector var2);

    /*
     * WARNING - void declaration
     */
    private void createParentFolderIfNotExists(String path) {
        void var1_1;
        File file;
        File file2 = file;
        void v1 = var1_1;
        if (!new File(v1.substring(0, v1.lastIndexOf(File.separator))).exists()) {
            file2.mkdirs();
        }
    }

    private String createNewPathIfInProcess(String path) {
        String string;
        Object object = ((LogProducerConfig)this_).context;
        if (object != null && !ProcessUtils.isMainProcess((Context)object)) {
            File file;
            Object this_ = ProcessUtils.getCurrentProcessName(((LogProducerConfig)this_).context);
            if (TextUtils.isEmpty((CharSequence)this_)) {
                return string;
            }
            void v0 = string;
            object = file;
            void v2 = string;
            string = File.separator;
            file = new File(v2.substring(0, v2.lastIndexOf(string)), (String)this_);
            this_ = v0.substring(v0.lastIndexOf(string) + 1);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            return new File((File)object, (String)this_).getAbsolutePath();
        }
        return string;
    }

    static {
        LogProducerConfig.loadNativeLibrary();
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void setEndpoint(String endpoint) {
        void var1_1;
        this.endpoint = var1_1;
        LogProducerConfig.log_producer_config_set_endpoint(this.config, (String)var1_1);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - void declaration
     */
    public void setProject(String project) {
        void var1_1;
        this.project = var1_1;
        LogProducerConfig.log_producer_config_set_project(this.config, (String)var1_1);
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogstore(String logstore) {
        void var1_1;
        this.logstore = var1_1;
        LogProducerConfig.log_producer_config_set_logstore(this.config, (String)var1_1);
    }

    public String getLogstore() {
        return this.logstore;
    }

    /*
     * WARNING - void declaration
     */
    public void setTopic(String topic) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_topic(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String key, String value) {
        void var2_2;
        void var1_1;
        LogProducerConfig.log_producer_config_add_tag(this.config, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessKeyId(String accessId) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_access_id(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessKeySecret(String accessKeySecret) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_access_key(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIsRum(String isRum) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_isRum(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPacketLogBytes(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_packet_log_bytes(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPacketLogCount(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_packet_log_count(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPacketTimeout(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_packet_timeout(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxBufferLimit(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_max_buffer_limit(this.config, (int)var1_1);
    }

    public void setSendThreadCount(int num) {
        boolean bl;
        if (this.enablePersistent && !bl) {
            bl = true;
        }
        LogProducerConfig.log_producer_config_set_send_thread_count(this.config, bl ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistent(int num) {
        void var1_1;
        boolean bl = true == var1_1;
        LogProducerConfig logProducerConfig = this;
        logProducerConfig.enablePersistent = bl;
        LogProducerConfig.log_producer_config_set_persistent(logProducerConfig.config, (int)var1_1);
        if (logProducerConfig.enablePersistent) {
            this.setSendThreadCount(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentFilePath(String path) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        LogProducerConfig logProducerConfig = string;
        ((LogProducerConfig)((Object)string)).createParentFolderIfNotExists((String)var1_1);
        String string = logProducerConfig.createNewPathIfInProcess((String)var1_1);
        LogProducerConfig.log_producer_config_set_persistent_file_path(logProducerConfig.config, string);
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentForceFlush(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_persistent_force_flush(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentMaxFileCount(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_persistent_max_file_count(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentMaxFileSize(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_persistent_max_file_size(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistentMaxLogCount(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_persistent_max_log_count(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUsingHttp(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_using_http(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setNetInterface(String netInterface) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_net_interface(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectTimeoutSec(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_connect_timeout_sec(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSendTimeoutSec(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_send_timeout_sec(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDestroyFlusherWaitSec(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_destroy_flusher_wait_sec(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDestroySenderWaitSec(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_destroy_sender_wait_sec(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCompressType(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_compress_type(this.config, (int)var1_1);
    }

    public void setCompressType(CompressType type) {
        LogProducerConfig.log_producer_config_set_compress_type(this.config, CompressType.LZ4.type);
    }

    /*
     * WARNING - void declaration
     */
    public void setNtpTimeOffset(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_ntp_time_offset(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLogDelayTime(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_max_log_delay_time(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDropDelayLog(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_drop_delay_log(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDropUnauthorizedLog(int num) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_drop_unauthorized_log(this.config, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCallbackFromSenderThread(boolean enable) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_callback_from_sender_thread(this.config, (int)var1_1);
    }

    public void setGetTimeUnixFunc(LogProducerTimeUnixFunc func) {
        LogProducerConfig.log_producer_config_set_get_time_unix_func(func);
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(String source) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_source(this.config, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void resetSecurityToken(String accessKeyID, String accessKeySecret, String securityToken) {
        void var3_3;
        void var2_2;
        void var1_1;
        LogProducerConfig.log_producer_config_reset_security_token(this.config, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    @Deprecated
    public void setUseWebtracking(boolean enable) {
    }

    public void logProducerDebug() {
        LogProducerConfig.log_producer_debug();
    }

    public long getConfig() {
        return this.config;
    }

    public int isValid() {
        return LogProducerConfig.log_producer_config_is_valid(this.config);
    }

    public int isEnabled() {
        return LogProducerConfig.log_producer_persistent_config_is_enabled(this.config);
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpHeaderInjector(LogProducerHttpHeaderInjector injector) {
        void var1_1;
        LogProducerConfig.log_producer_config_set_http_header_inject(this.config, (LogProducerHttpHeaderInjector)var1_1);
    }

    public static final class CompressType
    extends Enum<CompressType> {
        public static final /* enum */ CompressType LZ4;
        public static final /* enum */ CompressType ZSTD;
        private static final /* synthetic */ CompressType[] $VALUES;
        public final int type;

        public static CompressType[] values() {
            return (CompressType[])$VALUES.clone();
        }

        public static CompressType valueOf(String name) {
            String string;
            return Enum.valueOf(CompressType.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private CompressType(int type) {
            void var3_3;
            this.type = var3_3;
        }

        static {
            CompressType compressType;
            CompressType compressType2;
            CompressType compressType3 = compressType2;
            LZ4 = new CompressType(1);
            CompressType compressType4 = compressType;
            ZSTD = new CompressType(2);
            $VALUES = new CompressType[]{compressType3, compressType4};
        }
    }

    public static class DefaultNativeLibraryLoader
    implements NativeLibraryLoader {
        private DefaultNativeLibraryLoader() {
        }

        public /* synthetic */ DefaultNativeLibraryLoader(1 x0) {
            this();
        }

        @Override
        public void loadLibrary(String libraryName) throws UnsatisfiedLinkError {
            System.loadLibrary(libraryName);
        }
    }

    public static interface NativeLibraryLoader {
        public void loadLibrary(String var1) throws UnsatisfiedLinkError;
    }
}

