/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.config;

import android.text.TextUtils;
import android.util.Log;
import com.alibabacloud.rum.android.sdk.a.a;
import com.alibabacloud.rum.android.sdk.b1.b;
import com.alibabacloud.rum.config.LogHttpResponse;
import com.alibabacloud.rum.producer.utils.TimeUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.VisibleForTesting;

public class ConfigServerHttpTool {
    private static final String TAG = "ConfigServerHttpTool";
    private static NetworkInterface sNetworkInterface;

    public static void setNetworkInterface(NetworkInterface callback) {
        sNetworkInterface = callback;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static HttpURLConnection createConnection(String urlString, String method, String[] header) throws Exception {
        void var2_3;
        void var1_1;
        HttpURLConnection httpURLConnection;
        httpURLConnection = (HttpURLConnection)new URL((String)((Object)httpURLConnection)).openConnection();
        if ("post".equalsIgnoreCase((String)var1_1)) {
            httpURLConnection.setDoOutput(true);
        }
        httpURLConnection.setRequestMethod((String)var1_1);
        if (var2_3 != null) {
            int n2 = ((void)var2_3).length / 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2 * 2;
                void var4_5 = var2_3[n3];
                httpURLConnection.setRequestProperty((String)var4_5, (String)var2_3[n3 + 1]);
            }
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void writeToConnection(HttpURLConnection connection, String method, byte[] body) throws Exception {
        void var1_1;
        if ("post".equalsIgnoreCase((String)var1_1)) {
            void var2_2;
            HttpURLConnection httpURLConnection;
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((OutputStream)dataOutputStream).write((byte[])var2_2);
            dataOutputStream.flush();
            ((OutputStream)dataOutputStream).close();
        }
    }

    @VisibleForTesting
    public static void updateTimeFromResponse(Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return;
        }
        if ((object = object.get("Date")) != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            Object object2 = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = object;
                ((StringBuilder)object3).append((String)iterator.next());
                ((StringBuilder)object3).append(", ");
            }
            if ((object = ((StringBuilder)object).toString()) != null && !((String)object).isEmpty()) {
                long l2 = ConfigServerHttpTool.getTimestampWithSimpleDateFormat((String)object);
                b.a(TAG, "updateTimeFromResponse Date ms: " + l2);
                if (l2 > 1500000000000L && l2 < 4294967294000L) {
                    b.a(TAG, "updateTimeFromResponse serverTime ms: " + l2);
                    TimeUtils.getInstance().updateServerTime(l2);
                    com.alibabacloud.rum.android.sdk.n0.a.a(l2 * 1000L);
                }
            }
            return;
        }
        b.a(TAG, "updateTimeFromResponse Date is null ");
    }

    public static long getTimestampWithSimpleDateFormat(String dateString) {
        String string;
        if (dateString != null && !string.isEmpty()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                return simpleDateFormat.parse(string).getTime();
            }
            catch (ParseException parseException) {
                b.b(TAG, "Error parsing date string: " + string);
                return -1L;
            }
        }
        return -1L;
    }

    private static String getRequestIdFromResponse(Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return null;
        }
        if ((object = object.get("x-log-requestid")) != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            Object object2 = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = object;
                ((StringBuilder)object3).append((String)iterator.next());
                ((StringBuilder)object3).append(", ");
            }
            Object object4 = object;
            return ((StringBuilder)object4).substring(0, ((StringBuilder)object4).length() - 2);
        }
        return null;
    }

    @VisibleForTesting
    public static LogHttpResponse processResponse(HttpURLConnection connection) throws Exception {
        String string;
        StringBuilder stringBuilder;
        BufferedReader bufferedReader;
        InputStream inputStream;
        LogHttpResponse logHttpResponse;
        String string2 = connection.getHeaderField("x-log-requestid");
        if (string2 == null) {
            string2 = "";
        }
        LogHttpResponse logHttpResponse2 = logHttpResponse;
        logHttpResponse2();
        logHttpResponse.setRequestId(string2);
        logHttpResponse.setErrorMessage("");
        int n2 = ((HttpURLConnection)((Object)inputStream)).getResponseCode();
        logHttpResponse2.setStatusCode(n2);
        if (n2 / 100 == 2) {
            int n3;
            ByteArrayOutputStream byteArrayOutputStream;
            b.a(TAG, "code: " + n2);
            inputStream = ((URLConnection)((Object)inputStream)).getInputStream();
            if (inputStream == null) {
                b.e(TAG, "return null");
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 1024;
            byte[] byArray = new byte[1024];
            while ((n3 = inputStream.read(byArray, 0, n4)) != -1) {
                byteArrayOutputStream2.write(byArray, 0, n3);
            }
            LogHttpResponse logHttpResponse3 = logHttpResponse2;
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
            byteArrayOutputStream3.flush();
            logHttpResponse3.setBody(byteArrayOutputStream3.toByteArray());
            return logHttpResponse3;
        }
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader(((HttpURLConnection)((Object)inputStream)).getErrorStream()));
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        while ((string = bufferedReader2.readLine()) != null) {
            stringBuilder2.append(string);
        }
        bufferedReader2.close();
        logHttpResponse2.setErrorMessage(stringBuilder2.toString());
        if (ConfigServerHttpTool.shouldRetrySendData(n2, ((URLConnection)((Object)inputStream)).getHeaderFields())) {
            LogHttpResponse logHttpResponse4 = logHttpResponse2;
            b.e(TAG, "request may have been blocked. it will be retried. errorCode: " + stringBuilder2);
            logHttpResponse4.setStatusCode(-1);
            return logHttpResponse4;
        }
        b.e(TAG, "code: " + n2 + ", response: " + stringBuilder2);
        return logHttpResponse2;
    }

    @VisibleForTesting
    public static boolean shouldRetrySendData(int code, Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return true;
        }
        if ((object = (List)object.get("x-log-requestid")) != null && !object.isEmpty()) {
            int n2;
            StringBuilder stringBuilder;
            List list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object2 = object;
                ((StringBuilder)object2).append((String)iterator.next());
                ((StringBuilder)object2).append(", ");
            }
            Object object3 = object;
            object = ((StringBuilder)object3).substring(0, ((StringBuilder)object3).length() - 2);
            return 400 == n2 && TextUtils.isEmpty((CharSequence)object);
        }
        return true;
    }

    @VisibleForTesting
    public static long toLong(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LogHttpResponse android_http_post(String urlString, String[] header, byte[] body) {
        void var2_2;
        void var1_1;
        return ConfigServerHttpTool.android_http_post(urlString, "POST", (String[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static LogHttpResponse android_http_post(String urlString, String method, String[] header, byte[] body) {
        Object object;
        void var3_5;
        String string;
        String string2;
        Object object2 = TAG;
        String string3 = "android_http_post urlString: %s, header length: %d, body length: %d";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        int n2 = 1;
        Integer n3 = header != null ? ((void)string).length : 0;
        objectArray2[n2] = n3;
        n2 = 2;
        n3 = var3_5 != null ? ((void)var3_5).length : 0;
        objectArray2[n2] = n3;
        b.a((String)object2, string3, objectArray2);
        object2 = sNetworkInterface;
        if (object2 != null && (object2 = object2.send(string2, (String)object, (String[])string, (byte[])var3_5)) != null) {
            LogHttpResponse logHttpResponse;
            Object object3 = object2;
            ConfigServerHttpTool.updateTimeFromResponse(((NetworkResponse)object3).headers);
            if (ConfigServerHttpTool.shouldRetrySendData(((NetworkResponse)object3).statusCode, ((NetworkResponse)object2).headers)) {
                ((NetworkResponse)object2).statusCode = -1;
            }
            Object object4 = object2;
            string2 = ConfigServerHttpTool.getRequestIdFromResponse(((NetworkResponse)object4).headers);
            object = logHttpResponse;
            ((LogHttpResponse)object)();
            logHttpResponse.setStatusCode(((NetworkResponse)object2).statusCode);
            string = TextUtils.isEmpty((CharSequence)((NetworkResponse)object4).errorMessage) ? "" : ((NetworkResponse)object2).errorMessage;
            ((LogHttpResponse)object).setErrorMessage(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = "";
            }
            Object object5 = object;
            ((LogHttpResponse)object).setRequestId(string2);
            ((LogHttpResponse)object5).setBody(((NetworkResponse)object2).body);
            return object5;
        }
        try {
            HttpURLConnection httpURLConnection = ConfigServerHttpTool.createConnection(string2, (String)object, (String[])string);
            ConfigServerHttpTool.writeToConnection(httpURLConnection, (String)object, (byte[])var3_5);
            ConfigServerHttpTool.updateTimeFromResponse(httpURLConnection.getHeaderFields());
            return ConfigServerHttpTool.processResponse(httpURLConnection);
        }
        catch (Exception exception) {
            LogHttpResponse logHttpResponse;
            Log.w((String)TAG, (String)a.a("exception: ").append(exception.getLocalizedMessage()).toString());
            LogHttpResponse logHttpResponse2 = logHttpResponse;
            new LogHttpResponse().setStatusCode(-1);
            logHttpResponse2.setRequestId("");
            object = exception.getMessage();
            if (object == null) {
                object = "";
            }
            LogHttpResponse logHttpResponse3 = logHttpResponse2;
            logHttpResponse3.setErrorMessage((String)object);
            return logHttpResponse3;
        }
    }

    public static interface NetworkInterface {
        public NetworkResponse send(String var1, String var2, String[] var3, byte[] var4);
    }

    public static class NetworkResponse {
        public int statusCode;
        public Map<String, List<String>> headers;
        public String errorMessage = "";
        public byte[] body = null;
    }
}

