/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum;

import android.content.Context;
import android.text.TextUtils;
import com.alibabacloud.rum.capture.resource.customResource.Measuring;
import com.alibabacloud.rum.capture.resource.customTrace.TraceContext;
import com.alibabacloud.rum.core.ResourceSnapshotProvider;
import java.util.HashMap;
import java.util.Map;

public class AlibabaCloudRum {
    private static final String SDK_VERSION_PREFIX = "_sv_";
    private String env = Env.PROD.stringValue();
    private String endpoint = "";
    private String appId = "";

    AlibabaCloudRum() {
    }

    public AlibabaCloudRum withConfigAddress(String configAddress) {
        return this.withEndpoint(configAddress);
    }

    public AlibabaCloudRum withEndpoint(String endpointAddress) {
        if (TextUtils.isEmpty((CharSequence)endpointAddress)) {
            return SingletonHolder.INSTANCE;
        }
        this.endpoint = endpointAddress;
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withWorkspace(String workspace) {
        Agent.setWorkspace(workspace);
        return SingletonHolder.INSTANCE;
    }

    public static AlibabaCloudRum withServiceId(String serviceId) {
        Agent.setServiceId(serviceId);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withEnvironment(Env env) {
        this.env = env.stringValue();
        Agent.setEnvironment(this.env);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withCustomEnvironment(String env) {
        if (TextUtils.isEmpty((CharSequence)env)) {
            return SingletonHolder.INSTANCE;
        }
        this.env = env;
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withAppVersion(String appVersion) {
        Agent.setAppVersion(appVersion);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withDeviceID(String deviceID) {
        Agent.setDeviceId(deviceID);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum withChannelID(String channelID) {
        Agent.setAppChannel(channelID);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum start() {
        Agent.start(this.endpoint, this.appId);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum startSync() {
        Agent.start(this.endpoint, this.appId);
        return SingletonHolder.INSTANCE;
    }

    public AlibabaCloudRum start(Context context) {
        Agent.start(context, this.endpoint, this.appId);
        return SingletonHolder.INSTANCE;
    }

    public static void stop() {
        Agent.stop();
    }

    public static void setUserName(String userID) {
        Agent.setUserName(userID);
    }

    public static void setExtraInfo(Map<String, Object> extraInfo) {
        Agent.setExtraInfo(extraInfo);
    }

    public static void addExtraInfo(Map<String, Object> extraInfo) {
        Agent.addExtraInfo(extraInfo);
    }

    public static void setUserExtraInfo(Map<String, Object> extraInfo) {
        Agent.setUserExtraInfo(extraInfo);
    }

    public static void addUserExtraInfo(Map<String, Object> extraInfo) {
        Agent.setUserExtraInfo(extraInfo);
    }

    public static void setAppFramework(Framework framework) {
        Agent.setAppFramework(framework.getDescription());
    }

    public static void setCustomException(Throwable exception) {
        Agent.setCustomException(exception);
    }

    public static void setCustomException(String type, String caseBy, String message) {
        Agent.setCustomException(type, caseBy, message);
    }

    public static void setCustomMetric(String name, long value) {
    }

    public static void setCustomMetric(String name, long value, String param) {
    }

    public static void setCustomLog(String content) {
        AlibabaCloudRum.setCustomLog(content, null);
    }

    public static void setCustomLog(String content, String name) {
        AlibabaCloudRum.setCustomLog(content, name, null);
    }

    public static void setCustomLog(String content, String name, String snapshots) {
        AlibabaCloudRum.setCustomLog(content, name, snapshots, "INFO", null);
    }

    public static void setCustomLog(String content, String name, String snapshots, String level, Map<String, Object> attributes) {
        Agent.setCustomLog(content, name, snapshots, level, attributes);
    }

    public static void setCustomEvent(String eventName) {
        AlibabaCloudRum.setCustomEvent(eventName, null);
    }

    public static void setCustomEvent(String eventName, String group) {
        AlibabaCloudRum.setCustomEvent(eventName, group, (String)null);
    }

    public static void setCustomEvent(String eventName, String group, String snapshots) {
        AlibabaCloudRum.setCustomEvent(eventName, group, snapshots, 0.0);
    }

    public static void setCustomEvent(String eventName, String group, double value) {
        AlibabaCloudRum.setCustomEvent(eventName, group, null, value);
    }

    public static void setCustomEvent(String eventName, String group, Map<String, Object> attributes) {
        AlibabaCloudRum.setCustomEvent(eventName, group, null, attributes);
    }

    public static void setCustomEvent(String eventName, String group, String snapshots, double value) {
        AlibabaCloudRum.setCustomEvent(eventName, group, snapshots, value, null);
    }

    public static void setCustomEvent(String eventName, String group, String snapshots, Map<String, Object> attributes) {
        AlibabaCloudRum.setCustomEvent(eventName, group, snapshots, 0.0, attributes);
    }

    public static void setCustomEvent(String eventName, String group, double value, Map<String, Object> info) {
        AlibabaCloudRum.setCustomEvent(eventName, group, null, value, info);
    }

    public static void setCustomEvent(String eventName, String group, String snapshots, double value, Map<String, Object> attributes) {
        Agent.setCustomEvent(eventName, String.valueOf(value), group, snapshots, attributes);
    }

    public static String getDeviceId() {
        return Agent.getDeviceId();
    }

    public static void setDebuggable(boolean debuggable) {
        Agent.setDebuggable(debuggable);
    }

    public static void reportCustomResource(String type, String url, String method, int statusCode, String errorMessage, boolean success, String provider, TraceContext traceContext, Measuring measuring) {
        if (measuring == null) {
            measuring = new Measuring();
        }
        Agent.reportCustomResource(type, url, method, statusCode, errorMessage, success, provider, traceContext, measuring);
    }

    public static void setOkHttp2ResourceSnapshotProvider(ResourceSnapshotProvider provider) {
        Agent.setOkHttp2ResourceSnapshotProvider(provider);
    }

    public static void setOkHttp3ResourceSnapshotProvider(ResourceSnapshotProvider provider) {
        Agent.setOkHttp3ResourceSnapshotProvider(provider);
    }

    public static void setHttpUrlConnectionResourceSnapshotProvider(ResourceSnapshotProvider provider) {
        Agent.setHttpUrlConnectionResourceSnapshotProvider(provider);
    }

    private static class SingletonHolder {
        private static final AlibabaCloudRum INSTANCE = new AlibabaCloudRum();

        private SingletonHolder() {
        }
    }

    public static enum Framework {
        FLUTTER(0),
        REACT_NATIVE(1),
        UNITY(2);

        private final int value;

        private Framework(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public final String getDescription() {
            switch (this) {
                case FLUTTER: {
                    return "Flutter";
                }
                case REACT_NATIVE: {
                    return "ReactNative";
                }
                case UNITY: {
                    return "Unity";
                }
            }
            return null;
        }
    }

    public static enum Env {
        NONE(0),
        PROD(1),
        GRAY(2),
        PRE(3),
        DAILY(4),
        LOCAL(5);

        static final Map<Integer, String> sEnvStringMap;
        private final int value;

        private Env(int i2) {
            this.value = i2;
        }

        public final int getValue() {
            return this.value;
        }

        public final String stringValue() {
            return sEnvStringMap.get(this.value);
        }

        static {
            sEnvStringMap = new HashMap<Integer, String>(){
                {
                    this.put(NONE.getValue(), "none");
                    this.put(PROD.getValue(), "prod");
                    this.put(GRAY.getValue(), "gray");
                    this.put(PRE.getValue(), "pre");
                    this.put(DAILY.getValue(), "daily");
                    this.put(LOCAL.getValue(), "local");
                }
            };
        }
    }

    private static class Agent
    extends com.alibabacloud.rum.android.sdk.AlibabaCloudRum {
        private Agent() {
        }
    }
}

