/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.asm;

import com.alibabacloud.rum.android.plugin.asm.AlibabacloudRumMethodAdapter;
import com.alibabacloud.rum.android.plugin.common.AlibabacloudClassNameAnalytics;
import com.alibabacloud.rum.android.plugin.logger.Logger;
import com.alibabacloud.rum.android.plugin.manager.AlibabacloudRumPluginManager;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AlibabacloudRumClassAdapter
extends ClassVisitor {
    private String className;
    private String superName;
    private String[] interfaces;
    private boolean needSkip;

    public AlibabacloudRumClassAdapter(ClassVisitor cv) {
        super(AlibabacloudRumPluginManager.get().getASMVersion(), cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.superName = superName;
        this.interfaces = interfaces;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if ("/IgnoreAOP".equalsIgnoreCase(descriptor)) {
            this.needSkip = true;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (AlibabacloudClassNameAnalytics.isAlibabacloudRumApi(this.className)) {
            // empty if block
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (this.needSkip) {
            Logger.debug("ignoreAOP-> class:" + this.className + ",super:" + this.superName + ", method:" + name + desc);
            return mv;
        }
        return new AlibabacloudRumMethodAdapter(mv, access, name, desc, this.className, this.interfaces, this.superName);
    }
}

