/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.manager;

import com.alibabacloud.rum.android.plugin.extension.AlibabacloudRumExtension;
import com.alibabacloud.rum.android.plugin.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public class AlibabacloudRumPluginManager {
    private AlibabacloudRumExtension alibabacloudRumExtension;
    private String asmVersion = "asm7";
    private final List<String> normalizedExcludePrefixes = new ArrayList<String>();

    public static AlibabacloudRumPluginManager get() {
        return SingletonHolder.INSTANCE;
    }

    public void setExtension(AlibabacloudRumExtension extension) {
        this.alibabacloudRumExtension = extension;
        this.asmVersion = extension.asmVersion;
        this.initExcludeConfig(extension);
    }

    private void initExcludeConfig(AlibabacloudRumExtension extension) {
        this.normalizedExcludePrefixes.clear();
        if (extension.excludePackages != null && !extension.excludePackages.isEmpty()) {
            for (String pkg : extension.excludePackages) {
                if (pkg == null || pkg.trim().isEmpty()) continue;
                String normalized = pkg.trim().replace(".", "/");
                this.normalizedExcludePrefixes.add(normalized);
                Logger.debug("Added exclude package prefix: " + normalized);
            }
            Logger.debug("Total exclude packages configured: " + this.normalizedExcludePrefixes.size());
        }
    }

    public boolean isInUserExcludeList(String className) {
        if (className == null || className.isEmpty() || this.normalizedExcludePrefixes.isEmpty()) {
            return false;
        }
        for (String prefix : this.normalizedExcludePrefixes) {
            if (!className.startsWith(prefix)) continue;
            Logger.debug("Class excluded by user config: " + className + " (matched prefix: " + prefix + ")");
            return true;
        }
        return false;
    }

    public List<String> getExcludePrefixes() {
        return new ArrayList<String>(this.normalizedExcludePrefixes);
    }

    public int getASMVersion() {
        switch (this.asmVersion) {
            case "asm6": {
                return 393216;
            }
            case "asm7": {
                return 458752;
            }
            case "asm8": {
                return 524288;
            }
            case "asm9": {
                return 589824;
            }
        }
        return 458752;
    }

    private static class SingletonHolder {
        private static final AlibabacloudRumPluginManager INSTANCE = new AlibabacloudRumPluginManager();

        private SingletonHolder() {
        }
    }
}

