/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.agplegacy;

import com.alibabacloud.rum.android.plugin.agplegacy.AlibabacloudRumLegacyTransform;
import com.alibabacloud.rum.android.plugin.extension.AlibabacloudRumExtension;
import com.alibabacloud.rum.android.plugin.logger.Logger;
import com.alibabacloud.rum.android.plugin.manager.AlibabacloudRumPluginManager;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import java.util.Collections;
import org.gradle.api.Project;

public class LegacyPluginImpl {
    private Project project;
    private String TAG = "LegacyPluginImpl";

    public LegacyPluginImpl(Project project) {
        this.project = project;
    }

    public void init() {
        AppExtension appExtension = (AppExtension)this.project.getProperties().get("android");
        AlibabacloudRumExtension extension = (AlibabacloudRumExtension)this.project.getExtensions().create("AlibabacloudRumExt", AlibabacloudRumExtension.class, new Object[]{this.project});
        extension.asmVersion = "asm7";
        appExtension.registerTransform((Transform)new AlibabacloudRumLegacyTransform(this.project), new Object[]{Collections.EMPTY_LIST});
        this.project.afterEvaluate(p -> {
            AlibabacloudRumExtension ext = (AlibabacloudRumExtension)p.getExtensions().getByName("AlibabacloudRumExt");
            if (!ext.asmVersion.equals("asm7")) {
                Logger.debug("Legacy AGP mode detected: forcing ASM version from '" + ext.asmVersion + "' to 'asm7' for compatibility with AGP 4.x ~ 7.1.x");
                ext.asmVersion = "asm7";
            }
            AlibabacloudRumPluginManager.get().setExtension(ext);
            Logger.setDebug(ext.showLog);
            Logger.debug("ASM Version: " + ext.asmVersion + " (Legacy Transform for AGP 4.x ~ 7.1.x)");
        });
    }
}

