/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.producer;

import android.text.TextUtils;
import com.alibabacloud.rum.android.sdk.a.a;
import com.alibabacloud.rum.android.sdk.y0.b;
import com.alibabacloud.rum.producer.LogHttpResponse;
import com.alibabacloud.rum.producer.utils.TimeUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public class LogProducerHttpTool {
    private static final String TAG = "LogProducerHttpTool";
    private static NetworkInterface sNetworkInterface;

    public static void setNetworkInterface(NetworkInterface callback) {
        sNetworkInterface = callback;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static HttpURLConnection createConnection(String urlString, String method, String[] header) throws Exception {
        void var2_3;
        void var1_1;
        HttpURLConnection httpURLConnection;
        httpURLConnection = (HttpURLConnection)new URL((String)((Object)httpURLConnection)).openConnection();
        if ("POST".equalsIgnoreCase((String)var1_1)) {
            httpURLConnection.setDoOutput(true);
        }
        httpURLConnection.setRequestMethod((String)var1_1);
        if (var2_3 != null) {
            int n2 = ((void)var2_3).length / 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2 * 2;
                void var4_5 = var2_3[n3];
                httpURLConnection.setRequestProperty((String)var4_5, (String)var2_3[n3 + 1]);
            }
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void writeToConnection(HttpURLConnection connection, String method, byte[] body) throws Exception {
        void var1_1;
        if ("POST".equalsIgnoreCase((String)var1_1)) {
            void var2_2;
            HttpURLConnection httpURLConnection;
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((OutputStream)dataOutputStream).write((byte[])var2_2);
            dataOutputStream.flush();
            ((OutputStream)dataOutputStream).close();
        }
    }

    @VisibleForTesting
    public static void updateTimeFromResponse(Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return;
        }
        if ((object = object.get("x-log-time")) != null && !object.isEmpty()) {
            long l2;
            StringBuilder stringBuilder;
            Object object2 = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = object;
                ((StringBuilder)object3).append((String)iterator.next());
                ((StringBuilder)object3).append(", ");
            }
            Object object4 = object;
            object = ((StringBuilder)object4).substring(0, ((StringBuilder)object4).length() - 2);
            if (object != null && !((String)object).isEmpty() && (l2 = LogProducerHttpTool.toLong((String)object)) > 1500000000L && l2 < 0xFFFFFFFEL) {
                TimeUtils.getInstance().updateServerTime(l2);
            }
            return;
        }
    }

    private static String getRequestIdFromResponse(Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return null;
        }
        if ((object = object.get("x-log-requestid")) != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            Object object2 = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = object;
                ((StringBuilder)object3).append((String)iterator.next());
                ((StringBuilder)object3).append(", ");
            }
            Object object4 = object;
            return ((StringBuilder)object4).substring(0, ((StringBuilder)object4).length() - 2);
        }
        return null;
    }

    @VisibleForTesting
    public static LogHttpResponse processResponse(HttpURLConnection connection) throws Exception {
        String string;
        StringBuilder stringBuilder;
        BufferedReader bufferedReader;
        HttpURLConnection httpURLConnection;
        LogHttpResponse logHttpResponse;
        String string2 = connection.getHeaderField("x-log-requestid");
        if (string2 == null) {
            string2 = "";
        }
        LogHttpResponse logHttpResponse2 = logHttpResponse;
        logHttpResponse2();
        logHttpResponse.setRequestId(string2);
        logHttpResponse.setErrorMessage("");
        int n2 = httpURLConnection.getResponseCode();
        logHttpResponse2.setStatusCode(n2);
        if (n2 / 100 == 2) {
            b.a(TAG, "code: " + n2);
            return logHttpResponse2;
        }
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        while ((string = bufferedReader2.readLine()) != null) {
            stringBuilder2.append(string);
        }
        bufferedReader2.close();
        logHttpResponse2.setErrorMessage(stringBuilder2.toString());
        if (LogProducerHttpTool.shouldRetrySendData(n2, httpURLConnection.getHeaderFields())) {
            LogHttpResponse logHttpResponse3 = logHttpResponse2;
            b.e(TAG, "request may have been blocked. it will be retried. errorCode: " + stringBuilder2);
            logHttpResponse3.setStatusCode(-1);
            return logHttpResponse3;
        }
        b.e(TAG, "code: " + n2 + ", response: " + stringBuilder2);
        return logHttpResponse2;
    }

    @VisibleForTesting
    public static boolean shouldRetrySendData(int code, Map<String, List<String>> headers) {
        Object object;
        if (headers == null) {
            return true;
        }
        if ((object = (List)object.get("x-log-requestid")) != null && !object.isEmpty()) {
            int n2;
            StringBuilder stringBuilder;
            List list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object2 = object;
                ((StringBuilder)object2).append((String)iterator.next());
                ((StringBuilder)object2).append(", ");
            }
            Object object3 = object;
            object = ((StringBuilder)object3).substring(0, ((StringBuilder)object3).length() - 2);
            return 400 == n2 && TextUtils.isEmpty((CharSequence)object);
        }
        return true;
    }

    @VisibleForTesting
    public static long toLong(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LogHttpResponse android_http_post(String urlString, String[] header, byte[] body) {
        void var2_2;
        void var1_1;
        String string;
        String string2 = TAG;
        String string3 = "android_http_post urlString: %s, header length: %d, body length: %d";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        int n2 = 1;
        Integer n3 = header != null ? ((void)var1_1).length : 0;
        objectArray2[n2] = n3;
        n2 = 2;
        n3 = var2_2 != null ? ((void)var2_2).length : 0;
        objectArray2[n2] = n3;
        b.a(string2, string3, objectArray2);
        return LogProducerHttpTool.android_http_post(string, "POST", (String[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static LogHttpResponse android_http_post(String urlString, String method, String[] header, byte[] body) {
        void var3_5;
        String string;
        Object object;
        String string2;
        Object object2 = sNetworkInterface;
        if (object2 != null && (object2 = object2.send(string2, (String)object, (String[])string, (byte[])var3_5)) != null) {
            LogHttpResponse logHttpResponse;
            Object object3 = object2;
            LogProducerHttpTool.updateTimeFromResponse(((NetworkResponse)object3).headers);
            if (LogProducerHttpTool.shouldRetrySendData(((NetworkResponse)object3).statusCode, ((NetworkResponse)object2).headers)) {
                ((NetworkResponse)object2).statusCode = -1;
            }
            Object object4 = object2;
            string2 = LogProducerHttpTool.getRequestIdFromResponse(((NetworkResponse)object4).headers);
            object = logHttpResponse;
            ((LogHttpResponse)object)();
            logHttpResponse.setStatusCode(((NetworkResponse)object2).statusCode);
            string = TextUtils.isEmpty((CharSequence)((NetworkResponse)object4).errorMessage) ? "" : ((NetworkResponse)object2).errorMessage;
            ((LogHttpResponse)object).setErrorMessage(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = "";
            }
            Object object5 = object;
            ((LogHttpResponse)object5).setRequestId(string2);
            return object5;
        }
        try {
            HttpURLConnection httpURLConnection = LogProducerHttpTool.createConnection(string2, (String)object, (String[])string);
            LogProducerHttpTool.writeToConnection(httpURLConnection, (String)object, (byte[])var3_5);
            LogProducerHttpTool.updateTimeFromResponse(httpURLConnection.getHeaderFields());
            return LogProducerHttpTool.processResponse(httpURLConnection);
        }
        catch (Exception exception) {
            LogHttpResponse logHttpResponse;
            b.e(TAG, a.a("exception: ").append(exception.getLocalizedMessage()).toString());
            LogHttpResponse logHttpResponse2 = logHttpResponse;
            new LogHttpResponse().setStatusCode(-1);
            logHttpResponse2.setRequestId("");
            object = exception.getMessage();
            if (object == null) {
                object = "";
            }
            LogHttpResponse logHttpResponse3 = logHttpResponse2;
            logHttpResponse3.setErrorMessage((String)object);
            return logHttpResponse3;
        }
    }

    public static interface NetworkInterface {
        public NetworkResponse send(String var1, String var2, String[] var3, byte[] var4);
    }

    public static class NetworkResponse {
        public int statusCode;
        public Map<String, List<String>> headers;
        public String errorMessage = "";
    }
}

