/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.producer;

import android.text.TextUtils;
import com.alibabacloud.rum.producer.Log;
import com.alibabacloud.rum.producer.LogMonitorCallback;
import com.alibabacloud.rum.producer.LogProducerCallback;
import com.alibabacloud.rum.producer.LogProducerConfig;
import com.alibabacloud.rum.producer.LogProducerException;
import com.alibabacloud.rum.producer.LogProducerResult;
import com.alibabacloud.rum.producer.utils.ThreadUtils;
import com.alibabacloud.rum.producer.utils.TimeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.TestOnly;

public class LogProducerClient {
    private final LogProducerConfig config;
    private final long producer;
    private final long client;
    private boolean enable;

    /*
     * WARNING - void declaration
     */
    public LogProducerClient(LogProducerConfig logProducerConfig) throws LogProducerException {
        this((LogProducerConfig)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerClient(LogProducerConfig logProducerConfig, LogProducerCallback callback) throws LogProducerException {
        String string;
        long l2;
        void var1_1;
        this.config = var1_1;
        this.producer = l2 = LogProducerClient.create_log_producer(logProducerConfig.getConfig(), (LogProducerCallback)((Object)string));
        if (l2 != 0L) {
            this.client = l2 = LogProducerClient.get_log_producer_client(l2);
            if (l2 != 0L) {
                void v0 = var1_1;
                string = v0.getEndpoint();
                String string2 = v0.getProject();
                if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                    TimeUtils.getInstance().startUpdateServerTime(var1_1.getContext(), string, string2);
                }
                this.enable = true;
                return;
            }
            throw new LogProducerException("Can not create log producer client");
        }
        throw new LogProducerException("Can not create log producer");
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public LogProducerClient(LogProducerConfig logProducerConfig, long mockProducer, long mockClient, boolean mockEnable) {
        void var6_4;
        void var4_3;
        void var2_2;
        void var1_1;
        this.config = var1_1;
        this.producer = var2_2;
        this.client = var4_3;
        this.enable = var6_4;
    }

    private static native long create_log_producer(long var0, LogProducerCallback var2);

    private static native void log_producer_set_log_monitor_callback(LogMonitorCallback var0);

    private static native long get_log_producer_client(long var0);

    private static native int log_producer_client_add_log_with_len(long var0, long var2, int var4, String[] var5, String[] var6, int var7);

    private static native int log_producer_client_add_log_with_len_time_int32(long var0, long var2, int var4, byte[][] var5, byte[][] var6);

    private static native void destroy_log_producer(long var0);

    /*
     * WARNING - void declaration
     */
    public LogProducerResult addLog(Log log) {
        void var1_1;
        return this.addLog((Log)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerResult addLog(Log log, int flush) {
        void var1_2;
        if (this.enable && this.client != 0L && var1_2 != null) {
            void var2_3;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(var1_2.getContent());
            int n2 = linkedHashMap.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            int n3 = 0;
            for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
                String string = entry.getKey();
                if (string == null) {
                    string = "";
                }
                stringArray[n3] = string;
                if ((entry = entry.getValue()) == null) {
                    entry = "";
                }
                stringArray2[n3] = entry;
                ++n3;
            }
            LogProducerClient logProducerClient = this;
            long l2 = var1_2.getLogTime();
            return LogProducerResult.fromInt(logProducerClient.nativeAddLog(logProducerClient.client, l2, n2, stringArray, stringArray2, (int)var2_3));
        }
        return LogProducerResult.LOG_PRODUCER_INVALID;
    }

    /*
     * WARNING - void declaration
     */
    public LogProducerResult addLogRaw(byte[][] keys, byte[][] values) {
        void var2_3;
        void var1_2;
        if (this.enable && this.client != 0L && var1_2 != null && var2_3 != null) {
            long l2 = new Log().getLogTime();
            long l3 = this.client;
            int n2 = ((void)var1_2).length;
            return LogProducerResult.fromInt(this.nativeAddLogRaw(l3, l2, n2, (byte[][])var1_2, (byte[][])var2_3));
        }
        return LogProducerResult.LOG_PRODUCER_INVALID;
    }

    public void destroyLogProducer() {
        if (!this.enable) {
            return;
        }
        this.enable = false;
        ThreadUtils.exec(new Runnable(this){
            public final /* synthetic */ LogProducerClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                LogProducerClient logProducerClient = this.this$0;
                logProducerClient.nativeDestroyLogProducer(logProducerClient.producer);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void setLogMonitorCallback(LogMonitorCallback callback) {
        void var1_1;
        if (this.enable && var1_1 != null) {
            this.nativeSetLogMonitorCallback((LogMonitorCallback)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int nativeAddLog(long client, long logTime, int pairCount, String[] keys, String[] values, int flush) {
        void var8_6;
        void var7_5;
        void var6_4;
        void var5_3;
        void var3_2;
        return LogProducerClient.log_producer_client_add_log_with_len(client, (long)var3_2, (int)var5_3, (String[])var6_4, (String[])var7_5, (int)var8_6);
    }

    /*
     * WARNING - void declaration
     */
    public int nativeAddLogRaw(long client, long logTime, int pairCount, byte[][] keys, byte[][] values) {
        void var7_5;
        void var6_4;
        void var5_3;
        void var3_2;
        return LogProducerClient.log_producer_client_add_log_with_len_time_int32(client, (long)var3_2, (int)var5_3, (byte[][])var6_4, (byte[][])var7_5);
    }

    public void nativeDestroyLogProducer(long producer) {
        LogProducerClient.destroy_log_producer(producer);
    }

    public void nativeSetLogMonitorCallback(LogMonitorCallback callback) {
        LogProducerClient.log_producer_set_log_monitor_callback(callback);
    }
}

