/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin;

import com.alibabacloud.rum.android.plugin.agplegacy.LegacyPluginImpl;
import com.alibabacloud.rum.android.plugin.agpv80.V80PluginImpl;
import com.alibabacloud.rum.android.plugin.logger.Logger;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AlibabacloudRumPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        boolean useInstrumentationApi = this.isInstrumentationApiAvailable();
        boolean useTransformApi = this.isTransformApiAvailable();
        Logger.debug("AGP Version Detection - Instrumentation API available: " + useInstrumentationApi + ", Transform API available: " + useTransformApi);
        if (useInstrumentationApi) {
            Logger.debug("Using Instrumentation API (AGP 7.2+)");
            V80PluginImpl v80Plugin = new V80PluginImpl(project);
            v80Plugin.init();
        } else if (useTransformApi) {
            Logger.debug("Using Transform API (AGP 4.x ~ 7.1.x)");
            LegacyPluginImpl legacyPlugin = new LegacyPluginImpl(project);
            legacyPlugin.init();
        } else {
            throw new IllegalStateException("Unsupported Android Gradle Plugin version. This plugin requires AGP 4.x or later. Neither Instrumentation API (AGP 7.2+) nor Transform API (AGP 4.x ~ 7.x) is available.");
        }
    }

    private boolean isInstrumentationApiAvailable() {
        try {
            Class.forName("com.android.build.api.variant.Instrumentation");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isTransformApiAvailable() {
        try {
            Class.forName("com.android.build.api.transform.Transform");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

