/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.capture.nativecrash;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.alibabacloud.rum.android.sdk.i.b;
import com.alibabacloud.rum.android.sdk.m0.g;
import com.alibabacloud.rum.android.sdk.y0.a;
import com.alibabacloud.rum.capture.nativecrash.BreakpadInit;
import com.alibabacloud.rum.capture.nativecrash.NativeCrashInfo;
import java.io.File;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.TestOnly;
import org.json.JSONArray;

public class CaptureNativeCrashService
extends b {
    public static final String h = "CaptureNativeCrashService";
    public final Context f;
    public ExecutorService g = Executors.newSingleThreadExecutor(runnable -> {
        Runnable runnable2;
        Thread thread = new Thread(runnable2);
        thread.setUncaughtExceptionHandler((t, e2) -> com.alibabacloud.rum.android.sdk.x0.b.b(h, "Uncaught exception in native crash service"));
        return thread;
    });

    public static CaptureNativeCrashService a(g g2, a a2) {
        return new CaptureNativeCrashService(g2, a2);
    }

    public CaptureNativeCrashService(g g2, a a2) {
        super(g2, a2);
        this.f = g2.f();
    }

    private void c() {
        File file;
        File file2 = file;
        if (!new File(this.f.getFilesDir(), g.b.a().x() + "/crash").exists() && !this.a(file2, 3)) {
            com.alibabacloud.rum.android.sdk.x0.b.b(h, "Failed to create crash directory after max retries");
            return;
        }
        String string = file2.getAbsolutePath();
        BreakpadInit.c(string);
        if (!this.a(string, 3, 500L)) {
            com.alibabacloud.rum.android.sdk.x0.b.b(h, "Failed to process native crash after max retries.");
        }
    }

    @TestOnly
    public ExecutorService b() {
        return this.g;
    }

    @TestOnly
    public Context a() {
        return this.f;
    }

    @Override
    public String captureName() {
        return "native_crash";
    }

    @Override
    public String captureType() {
        return "crash";
    }

    @Override
    public void onInstall(com.alibabacloud.rum.android.sdk.o0.a a2) {
        com.alibabacloud.rum.android.sdk.x0.b.d(h, "start install");
        try {
            this.g.execute(this::c);
        }
        catch (Exception exception) {
            com.alibabacloud.rum.android.sdk.x0.b.b(h, "Failed to process native crash.");
        }
        com.alibabacloud.rum.android.sdk.x0.b.d(h, "end install");
    }

    @Override
    public void onUninstall(com.alibabacloud.rum.android.sdk.o0.a a2) {
        com.alibabacloud.rum.android.sdk.x0.b.d(h, "start uninstall");
        ExecutorService executorService = ((CaptureNativeCrashService)((Object)executorService)).g;
        if (executorService != null) {
            executorService.shutdown();
        }
        com.alibabacloud.rum.android.sdk.x0.b.d(h, "end uninstall");
    }

    /*
     * WARNING - void declaration
     */
    public void a(NativeCrashInfo nativeCrashInfo) {
        void var1_1;
        LinkedHashMap<String, Object> linkedHashMap;
        LinkedHashMap<String, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Object>(this, (NativeCrashInfo)var1_1){
            public final /* synthetic */ NativeCrashInfo val$nativeCrashInfo;
            public final /* synthetic */ CaptureNativeCrashService this$0;
            {
                void var1_1;
                1 v0 = this;
                1 v1 = this;
                this.this$0 = var1_1;
                this.val$nativeCrashInfo = nativeCrashInfo;
                ((AbstractMap)v1).put("timestamp", nativeCrashInfo.getTimeDateStamp() * 1000L);
                ((AbstractMap)v1).put("event_type", "exception");
                ((AbstractMap)v1).put("exception.escaped", Boolean.FALSE);
                ((AbstractMap)v1).put("exception.type", "crash");
                ((AbstractMap)v1).put("exception.subtype", "native");
                ((AbstractMap)this).put("exception.caused_by", nativeCrashInfo.getCrashReason());
                ((AbstractMap)v0).put("exception.name", nativeCrashInfo.getCrashReason());
                ((AbstractMap)v0).put("exception.stack", new JSONArray(nativeCrashInfo.getStackTraces()).toString());
                ((AbstractMap)this).put("exception.thread_id", nativeCrashInfo.getRequestingThread());
                ((AbstractMap)this).put("exception.message", nativeCrashInfo.getCrashReason());
                ((AbstractMap)this).put("thread.name", nativeCrashInfo.getRequestingThread());
                ((AbstractMap)this).put("view.id", ((CaptureNativeCrashService)var1_1).b.r());
                ((AbstractMap)this).put("view.name", ((CaptureNativeCrashService)var1_1).b.s());
                ((AbstractMap)this).put("session.id", ((CaptureNativeCrashService)var1_1).b.n());
                ((AbstractMap)this).put("user.id", ((CaptureNativeCrashService)var1_1).b.o());
                ((AbstractMap)this).put("user.name", ((CaptureNativeCrashService)var1_1).b.p());
                ((AbstractMap)this).put("user.tags", ((CaptureNativeCrashService)var1_1).b.q());
                ((AbstractMap)this).put("properties", ((CaptureNativeCrashService)var1_1).b.v());
                ((AbstractMap)this).put("net.ip", ((CaptureNativeCrashService)var1_1).b.k());
                ((AbstractMap)this).put("net.model", ((CaptureNativeCrashService)var1_1).b.l());
            }
        };
        com.alibabacloud.rum.android.sdk.y0.a.a("NativeCrash", (Map<String, Object>)linkedHashMap2, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(File dir, int maxRetries) {
        void var2_3;
        int n2 = 0;
        while (n2 <= var2_3) {
            block5: {
                void var1_2;
                if (!var1_2.mkdirs()) break block5;
                return true;
            }
            try {
                com.alibabacloud.rum.android.sdk.x0.b.b(h, "create crash dir failed");
                Thread.sleep(1000L);
                ++n2;
            }
            catch (Exception exception) {
                com.alibabacloud.rum.android.sdk.x0.b.b(h, "Error creating crash directory");
                ++n2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                com.alibabacloud.rum.android.sdk.x0.b.b(h, "Interrupted while creating directory");
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(String filePath, int maxRetries, long retryDelayMillis) {
        void var2_2;
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 <= var2_2) {
            block11: {
                void var1_1;
                block10: {
                    Handler handler;
                    List<NativeCrashInfo> list = BreakpadInit.b((String)var1_1);
                    if (list == null) break block10;
                    if (list.isEmpty()) break block10;
                    Handler handler2 = handler;
                    handler2(Looper.getMainLooper());
                    handler.post(() -> {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            this.a((NativeCrashInfo)iterator.next());
                        }
                    });
                }
                if (BreakpadInit.a((String)var1_1)) break block11;
                try {
                    com.alibabacloud.rum.android.sdk.x0.b.b(h, "Failed to delete crash files: " + (String)var1_1, new Object[0]);
                }
                catch (Exception exception) {
                    com.alibabacloud.rum.android.sdk.x0.b.b(h, "Error occurred during async native crash handling, retrying: " + n2);
                    if (++n2 > var2_2) continue;
                    try {
                        void var3_3;
                        Thread.sleep((long)var3_3);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            bl = true;
        }
        return bl;
    }
}

