/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.asm;

import com.alibabacloud.rum.android.plugin.asm.AlibabacloudRumUtils;
import com.alibabacloud.rum.android.plugin.common.AlibabacloudClassNameAnalytics;
import com.alibabacloud.rum.android.plugin.logger.Logger;
import com.alibabacloud.rum.android.plugin.manager.AlibabacloudRumPluginManager;
import com.alibabacloud.rum.android.plugin.transform.AlibabacloudRumHookConfig;
import com.alibabacloud.rum.android.plugin.transform.AlibabacloudRumMethodCell;
import com.alibabacloud.rum.android.plugin.transform.AlibabacloudRumSubMethodCell;
import com.alibabacloud.rum.android.plugin.transform.webview.AlibabacloudRumMethodType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class AlibabacloudRumMethodAdapter
extends AdviceAdapter {
    private final String[] interfaces;
    private final String className;
    private final String superName;
    private final String methodName;
    private final String nameDesc;
    private boolean isHasTracked = false;
    private boolean pubAndNoStaticAccess;
    private boolean needSkip = false;
    private static final List<String> TARGET_WEBVIEW_METHOD = Arrays.asList("loadUrl(Ljava/lang/String;)V", "loadUrl(Ljava/lang/String;Ljava/util/Map;)V", "loadData(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "loadDataWithBaseURL(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "postUrl(Ljava/lang/String;[B)V", "setWebViewClient(Landroid/webkit/WebViewClient;)V", "setWebChromeClient(Landroid/webkit/WebChromeClient;)V");

    public AlibabacloudRumMethodAdapter(MethodVisitor methodVisitor, int access, String name, String descriptor, String className, String[] interfaces, String supperName) {
        super(AlibabacloudRumPluginManager.get().getASMVersion(), methodVisitor, access, name, descriptor);
        this.methodName = name;
        this.superName = supperName;
        this.className = className;
        this.interfaces = interfaces;
        this.nameDesc = name + descriptor;
        boolean isSDKInner = this.innerSDKSkip(className);
        if (AlibabacloudRumUtils.isTargetClassInSpecial(className) || isSDKInner || !this.isClassShouldInstrument(className) || this.isWebViewInner(className, this.superName, this.nameDesc)) {
            if (!isSDKInner) {
                Logger.debug("skip-> class:" + className + ",super:" + supperName + ",desc:" + this.nameDesc);
            }
            this.needSkip = true;
        }
    }

    public void visitCode() {
        super.visitCode();
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.isHasTracked) {
            AlibabacloudRumHookConfig.mLambdaMethodCells.remove(this.nameDesc);
            if (!this.needSkip) {
                Logger.debug("Hooked Class<" + this.className + ">\u7684 method: " + this.methodName + ", desc:" + this.methodDesc);
            }
        }
    }

    public void visitInvokeDynamicInsn(String name1, String desc1, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name1, desc1, bsm, bsmArgs);
        try {
            AlibabacloudRumMethodCell alibabacloudRumMethodCell;
            Object object = bsmArgs[0];
            String desc2 = "";
            if (object instanceof Type) {
                desc2 = ((Type)object).getDescriptor();
            }
            if ((alibabacloudRumMethodCell = AlibabacloudRumHookConfig.LAMBDA_METHODS.get(Type.getReturnType((String)desc1).getDescriptor() + name1 + desc2)) != null) {
                Handle it = (Handle)bsmArgs[1];
                AlibabacloudRumHookConfig.mLambdaMethodCells.put(it.getName() + it.getDesc(), alibabacloudRumMethodCell);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        Logger.debug("visitMethodInsn-> owner:" + owner + ", name:" + name + ", desc:" + desc + ", itf:" + itf + ", needSkip: " + this.needSkip);
        if (this.needSkip) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if ("java/net/URL".equals(owner) && "openConnection".equals(name) && "()Ljava/net/URLConnection;".equals(desc)) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            String hookClass = "com/alibabacloud/rum/android/sdk/track/TrackInstrument";
            String hookMethod = "trackHttpUrlConnection";
            String hookDesc = "(Ljava/net/URLConnection;)Ljava/net/URLConnection;";
            this.mv.visitMethodInsn(184, hookClass, hookMethod, hookDesc, false);
            Logger.debug("Hooked URL.openConnection() in class: " + this.className);
            this.isHasTracked = true;
            return;
        }
        String method = name + desc;
        switch (owner) {
            case "okhttp3/OkHttpClient$Builder": {
                if (!"build()Lokhttp3/OkHttpClient;".contains(name + desc)) break;
                this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", "trackOkHttpBuilder", "(Lokhttp3/OkHttpClient$Builder;)Lokhttp3/OkHttpClient;", false);
                Logger.debug("CLASS_NAME_OKHTTP_BUILDER-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + name + desc + " | " + this.nameDesc);
                return;
            }
            case "com/squareup/okhttp/OkHttpClient": {
                if (!"newCall(Lcom/squareup/okhttp/Request;)Lcom/squareup/okhttp/Call;".contains(name + desc)) break;
                this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", "trackOkHttp2Client", desc.replaceFirst("\\(", "(Lcom/squareup/okhttp/OkHttpClient;"), itf);
                Logger.debug("CLASS_NAME_OKHTTP2_CLIENT-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + name + desc + " | " + this.nameDesc);
                return;
            }
            case "org/chromium/net/ExperimentalCronetEngine$Builder": {
                if (!"build()Lorg/chromium/net/ExperimentalCronetEngine;".contains(name + desc)) break;
                this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", "trackCronetBuilder", "(Lorg/chromium/net/ExperimentalCronetEngine$Builder;)Lorg/chromium/net/ExperimentalCronetEngine;", false);
                Logger.debug("CLASS_NAME_ORG_CHROMIUM_NET_EXPERIMENTAL_CRONET_ENGINE -> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + name + desc + " | " + this.nameDesc);
                return;
            }
            case "android/webkit/WebView": 
            case "com/reactnativecommunity/webview/RNCWebView": 
            case "com/tencent/smtt/sdk/WebView": {
                if (method.equals("setWebViewClient(Landroid/webkit/WebViewClient;)V")) {
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    int webViewClientVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebViewClient"));
                    this.mv.visitVarInsn(58, webViewClientVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, webViewClientVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", "setWebViewClient", "(Landroid/webkit/WebView;Landroid/webkit/WebViewClient;)V", itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, webViewClientVar);
                    Logger.debug("TARGET_WEBVIEW_METHOD-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + method + " | " + this.nameDesc);
                    break;
                }
                if (method.equals("setWebChromeClient(Landroid/webkit/WebChromeClient;)V")) {
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    int webChromeClientVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebChromeClient"));
                    this.mv.visitVarInsn(58, webChromeClientVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, webChromeClientVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", "setWebChromeClient", "(Landroid/webkit/WebView;Landroid/webkit/WebChromeClient;)V", itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, webChromeClientVar);
                    Logger.debug("TARGET_WEBVIEW_METHOD-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + method + " | " + this.nameDesc);
                    break;
                }
                if (!TARGET_WEBVIEW_METHOD.contains(method)) break;
                if (this.nameDesc.startsWith("access$")) {
                    Logger.debug("WebInner Ignore-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + this.nameDesc);
                    break;
                }
                if (method.equals("loadUrl(Ljava/lang/String;)V")) {
                    this.mv.visitInsn(92);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc.replaceFirst("\\(", "(Landroid/view/View;"), itf);
                } else if (method.equals("loadUrl(Ljava/lang/String;Ljava/util/Map;)V")) {
                    int headerMapVar = this.newLocal(Type.getType(Map.class));
                    int urlVar = this.newLocal(Type.getType(String.class));
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    this.mv.visitVarInsn(58, headerMapVar);
                    this.mv.visitVarInsn(58, urlVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, headerMapVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc.replaceFirst("\\(", "(Landroid/view/View;"), itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, headerMapVar);
                } else if (method.equals("loadData(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V")) {
                    int mimeTypeVar = this.newLocal(Type.getType(String.class));
                    int dataVar = this.newLocal(Type.getType(String.class));
                    int urlVar = this.newLocal(Type.getType(String.class));
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    this.mv.visitVarInsn(58, mimeTypeVar);
                    this.mv.visitVarInsn(58, dataVar);
                    this.mv.visitVarInsn(58, urlVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, dataVar);
                    this.mv.visitVarInsn(25, mimeTypeVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc.replaceFirst("\\(", "(Landroid/view/View;"), itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, dataVar);
                    this.mv.visitVarInsn(25, mimeTypeVar);
                } else if (method.equals("loadDataWithBaseURL(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V")) {
                    int historyUrlVar = this.newLocal(Type.getType(String.class));
                    int encodingVar = this.newLocal(Type.getType(String.class));
                    int mimeTypeVar = this.newLocal(Type.getType(String.class));
                    int dataVar = this.newLocal(Type.getType(String.class));
                    int urlVar = this.newLocal(Type.getType(String.class));
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    this.mv.visitVarInsn(58, historyUrlVar);
                    this.mv.visitVarInsn(58, encodingVar);
                    this.mv.visitVarInsn(58, mimeTypeVar);
                    this.mv.visitVarInsn(58, dataVar);
                    this.mv.visitVarInsn(58, urlVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, dataVar);
                    this.mv.visitVarInsn(25, mimeTypeVar);
                    this.mv.visitVarInsn(25, encodingVar);
                    this.mv.visitVarInsn(25, historyUrlVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc.replaceFirst("\\(", "(Landroid/view/View;"), itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, dataVar);
                    this.mv.visitVarInsn(25, mimeTypeVar);
                    this.mv.visitVarInsn(25, encodingVar);
                    this.mv.visitVarInsn(25, historyUrlVar);
                } else if (method.equals("postUrl(Ljava/lang/String;[B)V")) {
                    int postDataVar = this.newLocal(Type.getType((String)"[B"));
                    int urlVar = this.newLocal(Type.getType(String.class));
                    int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                    this.mv.visitVarInsn(58, postDataVar);
                    this.mv.visitVarInsn(58, urlVar);
                    this.mv.visitVarInsn(58, webViewVar);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, postDataVar);
                    this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc.replaceFirst("\\(", "(Landroid/view/View;"), itf);
                    this.mv.visitVarInsn(25, webViewVar);
                    this.mv.visitVarInsn(25, urlVar);
                    this.mv.visitVarInsn(25, postDataVar);
                }
                Logger.debug("TARGET_WEBVIEW_METHOD-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + method + " | " + this.nameDesc);
                break;
            }
            case "android/webkit/WebChromeClient": {
                if (!method.equals("onProgressChanged(Landroid/webkit/WebView;I)V")) break;
                int progressVar = this.newLocal(Type.INT_TYPE);
                int webViewVar = this.newLocal(Type.getObjectType((String)"android/webkit/WebView"));
                this.mv.visitVarInsn(54, progressVar);
                this.mv.visitVarInsn(58, webViewVar);
                this.mv.visitVarInsn(25, webViewVar);
                this.mv.visitVarInsn(21, progressVar);
                this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", name, desc, itf);
                this.mv.visitVarInsn(25, webViewVar);
                this.mv.visitVarInsn(21, progressVar);
                Logger.debug("TARGET_WEB_CHROME_CLIENT_METHOD-> owner:" + owner + ", class:" + this.className + ", super:" + this.superName + ", method:" + method + " | " + this.nameDesc);
                break;
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    protected void onMethodEnter() {
        super.onMethodEnter();
        this.pubAndNoStaticAccess = AlibabacloudRumUtils.isPublic(this.methodAccess) && !AlibabacloudRumUtils.isStatic(this.methodAccess);
        this.handleCode();
    }

    protected void onMethodExit(int opcode) {
        super.onMethodExit(opcode);
    }

    void handleCode(AlibabacloudRumMethodCell alibabacloudRumMethodCell) {
        if (alibabacloudRumMethodCell.subMethodCellList != null && !alibabacloudRumMethodCell.subMethodCellList.isEmpty()) {
            for (AlibabacloudRumSubMethodCell f : alibabacloudRumMethodCell.subMethodCellList) {
                if (f.type == AlibabacloudRumMethodType.ALOAD) {
                    this.mv.visitVarInsn(25, f.value);
                    continue;
                }
                if (f.type == AlibabacloudRumMethodType.ILOAD) {
                    this.mv.visitVarInsn(21, f.value);
                    continue;
                }
                if (f.type == AlibabacloudRumMethodType.INVOKEVIRTUAL) {
                    this.mv.visitMethodInsn(182, f.className, f.agentName, f.agentDesc, f.itf);
                    continue;
                }
                if (f.type == AlibabacloudRumMethodType.INVOKESPECIAL) {
                    this.mv.visitMethodInsn(183, f.className, f.agentName, f.agentDesc, f.itf);
                    continue;
                }
                if (f.type == AlibabacloudRumMethodType.GETSTATIC) {
                    this.mv.visitFieldInsn(178, f.className, f.agentName, f.agentDesc);
                    continue;
                }
                if (f.type == AlibabacloudRumMethodType.GETFIELD) {
                    this.mv.visitFieldInsn(180, f.className, f.agentName, f.agentDesc);
                    continue;
                }
                if (f.type != AlibabacloudRumMethodType.INVOKESTATIC) continue;
                this.mv.visitMethodInsn(184, f.className, f.agentName, f.agentDesc, f.itf);
            }
        }
    }

    void handleCode() {
        AlibabacloudRumMethodCell ftMethodCell;
        AlibabacloudRumMethodCell alibabacloudRumMethodCell;
        if (this.needSkip) {
            return;
        }
        if (AlibabacloudRumUtils.isInstanceOfApplication(this.superName) && (alibabacloudRumMethodCell = AlibabacloudRumHookConfig.APPLICATION_METHODS.get(this.nameDesc)) != null) {
            this.handleCode(alibabacloudRumMethodCell);
            this.isHasTracked = true;
            return;
        }
        if (AlibabacloudRumUtils.isInstanceOfActivity(this.className) && (ftMethodCell = AlibabacloudRumHookConfig.ACTIVITY_METHODS.get(this.nameDesc)) != null) {
            this.handleCode(ftMethodCell);
            this.isHasTracked = true;
            return;
        }
        AlibabacloudRumMethodCell lambdaMethodCell = AlibabacloudRumHookConfig.LAMBDA_METHODS.get(this.nameDesc);
        if (lambdaMethodCell != null) {
            Type[] types = Type.getArgumentTypes((String)lambdaMethodCell.desc);
            int length = types.length;
            Type[] lambdaTypes = Type.getArgumentTypes((String)this.methodDesc);
            int paramStart = lambdaTypes.length - length;
            if (paramStart < 0) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (lambdaTypes[paramStart + i].getDescriptor().equals(types[i].getDescriptor())) continue;
                return;
            }
            boolean isStaticMethod = AlibabacloudRumUtils.isStatic(this.methodAccess);
            if (!isStaticMethod && "(Landroid/view/MenuItem;)Z".equals(lambdaMethodCell.desc)) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, this.getVisitPosition(lambdaTypes, paramStart, isStaticMethod));
                this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", lambdaMethodCell.agentName, "(Ljava/lang/Object;Landroid/view/MenuItem;)V", false);
                Logger.debug("\u65b9\u6cd5\u626b\u63cf>>>\u7c7b\u662fLambda>>>\u65b9\u6cd5\u662f visitMethodInsn: " + this.nameDesc + " agent: " + lambdaMethodCell.agentName);
                this.isHasTracked = true;
                return;
            }
            for (int i = paramStart; i < paramStart + lambdaMethodCell.paramsCount; ++i) {
                this.mv.visitVarInsn(lambdaMethodCell.opcodes.get(i - paramStart).intValue(), this.getVisitPosition(lambdaTypes, i, isStaticMethod));
            }
            Logger.debug("\u65b9\u6cd5\u626b\u63cf>>>\u7c7b\u662fLambda>>>\u65b9\u6cd5\u662f visitMethodInsn: " + this.nameDesc + " agent: " + lambdaMethodCell.agentName);
            this.mv.visitMethodInsn(184, "com/alibabacloud/rum/android/sdk/track/TrackInstrument", lambdaMethodCell.agentName, lambdaMethodCell.agentDesc, false);
            this.isHasTracked = true;
            return;
        }
        if (!this.pubAndNoStaticAccess) {
            Logger.debug("\u65b9\u6cd5\u626b\u63cf>>>\u7c7b\u662f" + this.className + ">>>\u65b9\u6cd5\u662f" + this.nameDesc + " \u9759\u6001\u548c\u975e\u516c\u5171\u65b9\u6cd5");
            return;
        }
        if ((this.className.startsWith("android/") || this.className.startsWith("androidx/")) && !this.className.startsWith("android/support/v17/leanback") && !this.className.startsWith("androidx/leanback")) {
            return;
        }
        if (AlibabacloudRumUtils.isTargetMenuMethodDesc(this.nameDesc)) {
            this.handleCode(AlibabacloudRumHookConfig.MENU_METHODS);
            this.isHasTracked = true;
            return;
        }
        if (this.methodDesc.equals("(Landroid/view/View;)V")) {
            this.handleCode(AlibabacloudRumHookConfig.CLICK_METHOD);
            this.isHasTracked = true;
            return;
        }
    }

    int getVisitPosition(Type[] types, int index, boolean isStaticMethod) {
        if (types == null || index < 0 || index >= types.length) {
            throw new Error("getVisitPosition error");
        }
        if (index == 0) {
            return isStaticMethod ? 0 : 1;
        }
        return this.getVisitPosition(types, index - 1, isStaticMethod) + types[index - 1].getSize();
    }

    private boolean innerSDKSkip(String className) {
        return AlibabacloudClassNameAnalytics.isAlibabacloudRumPackage(className) && !AlibabacloudClassNameAnalytics.isAlibabacloudRumApi(className);
    }

    private boolean isClassShouldInstrument(String className) {
        if (className.startsWith("android/")) {
            return className.equals("android/support/v4/view/ViewPager");
        }
        return !(className.startsWith("com/google/") && !className.startsWith("com/google/net/cronet/okhttptransport") || className.startsWith("ohos/") || className.startsWith("javax/") || className.startsWith("java/") || className.startsWith("org/") && !className.startsWith("org/jeremyup/cordova") && !className.startsWith("org/apache/cordova") || className.startsWith("org/chromium/") || className.startsWith("bolts/") || className.startsWith("kotlin/") || className.startsWith("kotlinx/") || className.startsWith("io/reactivex") || className.startsWith("io/netty") || className.startsWith("io/realm") || className.startsWith("com/fasterxml") || className.startsWith("com/openrum/sdk") && !className.equals("com/openrum/sdk/agent/business/util/URLConnectionOpen") && !className.equals("com/openrum/sdk/agent/Agent") || className.startsWith("com/networkbench/") || className.startsWith("com/blueware/") || className.startsWith("com/mato/sdk/") || className.startsWith("com/sensorsdata") || className.startsWith("com/hianalytics/android/") || className.startsWith("com/tencent/qapmsdk") || className.startsWith("io/dcloud") || className.startsWith("com/bumptech/glide") || className.startsWith("com/facebook/fresco") || className.startsWith("com/chad") || className.startsWith("androidx") && !className.equals("androidx/viewpager/widget/ViewPager") || className.startsWith("com/tencent/tinker") || className.startsWith("com/taobao/sophix") || className.startsWith("cn/passguard/") || className.startsWith("com/huawei") || className.startsWith("com/xiaomi") || className.startsWith("com/baidu") || className.startsWith("com/iflytek/") || className.startsWith("com/megvii") || className.startsWith("com/umeng/") || className.startsWith("com/tencent/qcloud/core") || className.startsWith("com/tencent/smtt/sdk") || className.startsWith("com/tencent/wework/transition/appbrand") || className.startsWith("com/tencent/mm/api") || className.equals("com/pingan/isp/main/fragment/ZJMainFragment") || className.startsWith("com/mitake/core/") || className.equals("com/paic/zhifu/wallet/activity/modules/loginv4/LoginActivityV4") || className.startsWith("com/hundsun/imsdk") || className.startsWith("com/tdx/Android/UIJyWebView") || className.startsWith("com/example/zxjt108") || className.startsWith("com/wxgzs") || className.startsWith("com/yitong/mobile/network/utils") || className.startsWith("com/uc/webview/export/internal/setup") || className.startsWith("com/liulishuo") || className.startsWith("com/tapsdk/tapad") || className.startsWith("com/ak/") || className.startsWith("com/starnews2345/pluginsdk/plugin")) && !className.startsWith("com/ctetin/expandabletextviewlibrary");
    }

    private boolean isWebViewInner(String className, String superName, String methodNameDesc) {
        return false;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if ("Lcom/alibabacloud/rum/android/sdk/garble/annotation/IgnoreAOP".equals(descriptor)) {
            Logger.debug("ignoreAOP-> class:" + this.className + ",super:" + this.superName + ", method:" + this.methodName);
            this.needSkip = true;
            return null;
        }
        return super.visitAnnotation(descriptor, visible);
    }
}

