/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.agplegacy;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.AppExtension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.Project;

public class ClassLoaderHelper {
    public static URLClassLoader getClassLoader(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, Project project) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String androidJarPath = ClassLoaderHelper.getAndroidJarPath(project);
        File file = new File(androidJarPath);
        URL androidJarURL = file.toURI().toURL();
        urls.add(androidJarURL);
        ArrayList<TransformInput> allInputs = new ArrayList<TransformInput>(inputs);
        allInputs.addAll(referencedInputs);
        for (TransformInput totalInput : allInputs) {
            for (DirectoryInput directoryInput : totalInput.getDirectoryInputs()) {
                if (!directoryInput.getFile().isDirectory()) continue;
                urls.add(directoryInput.getFile().toURI().toURL());
            }
            for (JarInput jarInput : totalInput.getJarInputs()) {
                if (!jarInput.getFile().isFile()) continue;
                urls.add(jarInput.getFile().toURI().toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private static String getAndroidJarPath(Project project) {
        AppExtension appExtension = (AppExtension)project.getProperties().get("android");
        Object sdkDirectory = appExtension.getSdkDirectory().getAbsolutePath();
        String compileSdkVersion = appExtension.getCompileSdkVersion();
        sdkDirectory = (String)sdkDirectory + File.separator + "platforms" + File.separator;
        return (String)sdkDirectory + compileSdkVersion + File.separator + "android.jar";
    }
}

