/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.rum.android.plugin.agplegacy;

import com.alibabacloud.rum.android.plugin.agplegacy.ClassLoaderHelper;
import com.alibabacloud.rum.android.plugin.agplegacy.ExtendClassWriter;
import com.alibabacloud.rum.android.plugin.asm.AlibabacloudRumClassAdapter;
import com.alibabacloud.rum.android.plugin.common.AlibabacloudClassNameAnalytics;
import com.alibabacloud.rum.android.plugin.extension.AlibabacloudRumExtension;
import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AlibabacloudRumLegacyTransform
extends Transform {
    private final Project project;
    protected ClassLoader classLoader;
    private static final FileTime ZERO = FileTime.fromMillis(0L);

    public AlibabacloudRumLegacyTransform(Project project) {
        this.project = project;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        HashSet<QualifiedContent.ContentType> types = new HashSet<QualifiedContent.ContentType>();
        types.add((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES);
        return types;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        HashSet<QualifiedContent.Scope> scopes = new HashSet<QualifiedContent.Scope>();
        scopes.add(QualifiedContent.Scope.PROJECT);
        scopes.add(QualifiedContent.Scope.SUB_PROJECTS);
        scopes.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        return scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        AlibabacloudRumExtension alibabacloudRumExtension = (AlibabacloudRumExtension)this.project.getExtensions().getByName("AlibabacloudRumExt");
        this.transformFun(transformInvocation.getContext(), transformInvocation.getInputs(), transformInvocation.getReferencedInputs(), transformInvocation.getOutputProvider(), transformInvocation.isIncremental());
    }

    private void transformFun(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referenceInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws TransformException, InterruptedException, IOException {
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        this.classLoader = ClassLoaderHelper.getClassLoader(inputs, referenceInputs, this.project);
        for (TransformInput input : inputs) {
            Collection jarInputs = input.getJarInputs();
            for (JarInput jarInput : jarInputs) {
                this.processJarFile(jarInput, outputProvider, isIncremental);
            }
            Collection directoryInputs = input.getDirectoryInputs();
            for (DirectoryInput directoryInput : directoryInputs) {
                this.processDirectoryFile(directoryInput, outputProvider, isIncremental);
            }
        }
    }

    private void processJarFile(JarInput jarInput, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException {
        File file = jarInput.getFile();
        File outFile = outputProvider.getContentLocation(jarInput.getFile().getAbsolutePath(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
        if (isIncremental) {
            switch (jarInput.getStatus()) {
                case NOTCHANGED: {
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    this.modifyJar(file, outFile);
                    break;
                }
                case REMOVED: {
                    if (!outFile.exists()) break;
                    FileUtils.forceDelete((File)outFile);
                }
            }
        } else {
            this.modifyJar(file, outFile);
        }
    }

    private void modifyJar(File inputJar, File outputJar) throws IOException {
        if (inputJar == null || inputJar.length() == 0L) {
            return;
        }
        ZipFile inputZip = new ZipFile(inputJar);
        ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(outputJar.toPath(), new OpenOption[0])));
        Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
        while (inEntries.hasMoreElements()) {
            ZipEntry zipEntry = inEntries.nextElement();
            BufferedInputStream originalFile = new BufferedInputStream(inputZip.getInputStream(zipEntry));
            ZipEntry outEntry = new ZipEntry(zipEntry.getName());
            byte[] newEntryContent = !AlibabacloudClassNameAnalytics.isClass(outEntry.getName().replace("/", ".")) ? IOUtils.toByteArray((InputStream)originalFile) : this.handleBytes(originalFile);
            CRC32 crc32 = new CRC32();
            crc32.update(newEntryContent);
            outEntry.setCrc(crc32.getValue());
            outEntry.setMethod(0);
            outEntry.setSize(newEntryContent.length);
            outEntry.setCompressedSize(newEntryContent.length);
            outEntry.setLastAccessTime(ZERO);
            outEntry.setLastModifiedTime(ZERO);
            outEntry.setCreationTime(ZERO);
            outputStream.putNextEntry(outEntry);
            outputStream.write(newEntryContent);
            outputStream.closeEntry();
        }
        outputStream.flush();
        outputStream.close();
    }

    private void processDirectoryFile(DirectoryInput directoryInput, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException {
        File outFile = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
        FileUtils.forceMkdir((File)outFile);
        if (isIncremental) {
            String srcDirPath = directoryInput.getFile().getAbsolutePath();
            String outDirPath = outFile.getAbsolutePath();
            for (Map.Entry changeFile : directoryInput.getChangedFiles().entrySet()) {
                Status status = (Status)changeFile.getValue();
                File inputFile = (File)changeFile.getKey();
                String outFilePath = inputFile.getAbsolutePath().replace(srcDirPath, outDirPath);
                File outNewFile = new File(outFilePath);
                switch (status) {
                    case NOTCHANGED: {
                        break;
                    }
                    case ADDED: 
                    case CHANGED: {
                        FileUtils.forceMkdirParent((File)outNewFile);
                        this.modifyFile(inputFile, outNewFile, srcDirPath);
                        break;
                    }
                    case REMOVED: {
                        if (!outNewFile.exists()) break;
                        outNewFile.delete();
                    }
                }
            }
        } else {
            this.modifyDir(directoryInput.getFile(), outFile);
        }
    }

    private void modifyFile(File inputFile, File outFile, String srcBaseDir) throws IOException {
        if (!((String)srcBaseDir).endsWith(File.separator)) {
            srcBaseDir = (String)srcBaseDir + File.separator;
        }
        if (AlibabacloudClassNameAnalytics.isClass(inputFile.getAbsolutePath().replace((CharSequence)srcBaseDir, "").replace(File.separator, "."))) {
            FileUtils.touch((File)outFile);
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] bytes = this.handleBytes(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(outFile);
            fileOutputStream.write(bytes);
            fileOutputStream.close();
            ((InputStream)inputStream).close();
        } else if (inputFile.isFile()) {
            FileUtils.touch((File)outFile);
            FileUtils.copyFile((File)inputFile, (File)outFile);
        }
    }

    private void modifyDir(File inputDir, File outDir) throws IOException {
        String inputDirPath = inputDir.getAbsolutePath();
        String outDirPath = outDir.getAbsolutePath();
        if (!inputDir.isDirectory()) {
            return;
        }
        for (File file : FileUtils.listFiles((File)inputDir, null, (boolean)true)) {
            String filePath = file.getAbsolutePath();
            File outputFile = new File(filePath.replace(inputDirPath, outDirPath));
            this.modifyFile(file, outputFile, inputDirPath);
        }
    }

    private byte[] handleBytes(InputStream inputStream) throws IOException {
        ClassReader classReader = new ClassReader(inputStream);
        ExtendClassWriter classWriter = new ExtendClassWriter(this.classLoader, 1);
        AlibabacloudRumClassAdapter classVisitor = new AlibabacloudRumClassAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)classVisitor, 8);
        return classWriter.toByteArray();
    }
}

